/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

    @version $Id: EcatFoE_FH_Process.c 44462 2014-04-01 08:21:08Z Sven $

**************************************************************************************/

#ifndef __ECAT_FOE_FUNCTIONLIST_H
#define __ECAT_FOE_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat FoE function list, prototyes */

TLR_RESULT  TaskExit_EcatFoE (void* pvRsc);

TLR_RESULT  TaskLeave_EcatFoE(void* pvRsc,
                              void* pvLve);

void        TaskEnter_EcatFoE(void* pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_FOE_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_FOE_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_FOE_STARTUPPARAMETER_Ttag  ECAT_FOE_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_FOE_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_FOE_FUNCTIONLIST_H */
